// $Id: CLfoPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CLfoPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CLfoPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CLfoPanel, CControlPanel);

//	===========================================================================
CLfoPanel::CLfoPanel(IControlRoot *root, const long uniqueId, const CRect &area, CMenu *divisionMenu)
		 : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
		 , m_lfoBpmEditBox(NULL)
		 , m_lfoDivisionComboBox(NULL)
		 , m_lfoOutputValueLabel(NULL)
		 , m_lfoDivision(CMusicMath::e_quarterBar)
{
	EXPONENT_CLASS_CONSTRUCTION(CLfoPanel);

	this->onDrawDrawThePanelBounds(false);

	const long top    = 9;
	const long width  = 74;
	const long height = 20;

	// BPM edit
	m_lfoBpmEditBox			  = new CTextEdit(this,  e_lfoBpmEditBox,					CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_lfoDivisionComboBox	  = new CComboBox(this,  e_lfoDivisionComboBox,			    CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "1/4", divisionMenu, this);
	m_lfoOutputValueLabel	  = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_lfoBpmEditBox->referenced();
	m_lfoDivisionComboBox->referenced();
	m_lfoOutputValueLabel->referenced();

	// Set the format
	m_lfoBpmEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_lfoDivisionComboBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_lfoOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_lfoBpmEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_lfoBpmEditBox->setSingleClickEditable();

	// Colours
	m_lfoBpmEditBox->setColours(			CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_lfoDivisionComboBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_lfoOutputValueLabel->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Create the attributes to pass to the windows
	m_lfoDivisionComboBox->setMenuWindowAttributes(&CSCalWindow::CSCALWINDOW_MENU_WINDOW_ATTRIBUTES, false);
	m_lfoDivisionComboBox->setFont(CFont::CFONT_SYSTEM_FONT);

	// Colours of menus. Notice that this *must* be called after the menu window attributes, otherwise there isnt a window to open
	m_lfoDivisionComboBox->setMenuColours(CSCalWindow::CSCALWINDOW_MENU_COLOURS);

	// Add controls
	this->addControl(m_lfoOutputValueLabel);
	this->addControl(m_lfoDivisionComboBox);
	this->addControl(m_lfoBpmEditBox);

	// Compute
	this->computeLfoRate();
}

//	===========================================================================
CLfoPanel::~CLfoPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CLfoPanel);

	FORGET_COUNTED_OBJECT(m_lfoBpmEditBox);
	FORGET_COUNTED_OBJECT(m_lfoDivisionComboBox);
	FORGET_COUNTED_OBJECT(m_lfoOutputValueLabel);
}

//	===========================================================================
void CLfoPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_lfoDivisionComboBox:
			{
				const CMenuItem *item = m_lfoDivisionComboBox->getLastMenuItem();

				// Check item is valid
				if (item == NULL)
				{
					CDialog::notifyUser("Please select a valid tempo division", "SCal Error");
					return;
				}

				// Store the id
				m_lfoDivision = (CMusicMath::ETempoDivision)item->getId();
			}
			// Fall through
		case e_lfoBpmEditBox:
		case e_lfoTimeSigNumerator:
		case e_lfoTimeSigDenominator:
			this->computeLfoRate();
		break;
	}
}

//	===========================================================================
void CLfoPanel::computeLfoRate()
{
	double bpm = CString::toDouble(m_lfoBpmEditBox->getString().getString());
	
	if (bpm <= 0.0 || bpm >= 1000.0)
	{
		CDialog::notifyUser("BPM range error!\n\n0 < bpm < 1000\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm = 120.0;
		m_lfoBpmEditBox->setText("120.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm);
		m_lfoBpmEditBox->setText(string);
	}
	m_lfoBpmEditBox->update();

	// Store the output
	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getRateInHertz(bpm, m_lfoDivision));
	m_lfoOutputValueLabel->setText(output);
	m_lfoOutputValueLabel->update();
}